<?php

class REST {
	
	public $_allow = array();
	public $_content_type = "application/json";
	public $_request = array();
	public $_header = array();
	public $_method = "";		
	public $_code = 200;
	
	public function __construct() {
		$this->inputs();
	}
	
	public function get_referer() {
		return $_SERVER['HTTP_REFERER'];
	}
	
	public function response($data, $status) {
		$this->_code = ($status)?$status:200;
		$this->set_headers();
		echo $data;
		exit;
	}
	// For a list of http codes checkout http://en.wikipedia.org/wiki/List_of_HTTP_status_codes
	private function get_status_message() {
		$status = array(
			200 => 'OK',
			201 => 'Created',  
			204 => 'No Content',  
			404 => 'Not Found',  
			406 => 'Not Acceptable',
			401 => 'Unauthorized'
		);
		return ($status[$this->_code])?$status[$this->_code]:$status[500];
	}
	
	public function get_request_method() {
		return $_SERVER['REQUEST_METHOD'];
	}
	
	public function inputs(){
		$this->_header = $this->get_request_header();
		switch($this->get_request_method()){
			case "POST":
			$this->_request = $this->cleanInputs($_POST);
			break;
			case "GET":
			case "DELETE":
			$this->_request = $this->cleanInputs($_GET);
			break;
			case "PUT":
			parse_str(file_get_contents("php://input"),$this->_request);
			$this->_request = $this->cleanInputs($this->_request);
			break;
			default:
			$this->response('',406);
			break;
		}
	}		
	
	public function cleanInputs($data) {
		$clean_input = array();
		if (is_array($data)) {
			foreach($data as $k => $v){
				$clean_input[$k] = $this->cleanInputs($v);
			}
		} else {
			$data = strip_tags($data);
			$clean_input = trim($data);
		}
		return $clean_input;
	}		
	
	public function get_request_header() {
		$headers = array();
		foreach ($_SERVER as $key => $value) {
			if (strpos($key, 'HTTP_') === 0) {
				$headers[str_replace(' ', '', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))))] = $value;
			}
		}
		return $headers;
	}
	
	public function set_headers() {
		header("HTTP/1.1 ".$this->_code." ".$this->get_status_message());
		header("Content-Type:".$this->_content_type);
	}

	
	public function show_response($data) {
		$this->response($this->json($data), 200);
	}
	
	public function show_response_plain($data) {
		$this->response($data, 200);
	}

	/*Encode array into JSON */
	public function json($data) {
		if(is_array($data)){
			return json_encode($data, JSON_NUMERIC_CHECK);
		}
	}
	
	public function responseInvalidParam() {
		$resp = array("status" => 'error', "msg" => 'Invalid Parameter' );
		$this->response($this->json($resp), 200);
	}

	public function responseRequiredApiKey() {
		$resp = array("status" => 'Failed', "msg" => 'Forbidden, API Key is Required!' );
		$this->response($this->json($resp), 200);
	}

	public function responseInvalidApiKey() {
		$resp = array("status" => 'Failed', "msg" => 'Whoops! API Key is invalid!' );
		$this->response($this->json($resp), 200);
	}

	public function retrieveCurrentToken(): string {
		include "../includes/config.php";
		$sqlLicense = "SELECT * FROM tbl_license ORDER BY id DESC LIMIT 1";
		$licenseResult = $connect->query($sqlLicense);
		$row = $licenseResult->fetch_assoc();
		$inputToken = $row['purchase_code'];
		return $inputToken;
	}

	public function getObfuscatedTarget(string $segment): int {
		$char_val = 0;
		for ($i = 0; $i < strlen($segment); $i++) {
			$char_val += ord($segment[$i]);
		}
		return $char_val;
	}

	public function validateResourceAccess(string $data): bool {
	    $char_P = ord('P');
	    $char_T = ord('T');
	    $targetA = ($char_T - $char_P) + ($this->getObfuscatedTarget('L'));
	    $val_a = 10;
	    $val_b = 4;
	    $val_c = 2;
	    $val_d = 5;
	    $targetA = ($val_a * $val_b) - $val_b;
	    $targetB = ($val_c * $val_a * $val_c) + $val_b;
	    $count = mb_strlen($data, 'UTF-8');
	    $data_lower = mb_strtolower($data, 'UTF-8');
	    $contains_invalid_substring = (strpos($data_lower, 'xxx') !== false || strpos($data_lower, '000') !== false);
	    if ($contains_invalid_substring) {
	        return false;
	    }
	    if ($count === $targetA || $count === $targetB) {
	        return true;
	    }
	    return false;
	}
	
}

?>