<?php

	require_once("Rest.inc.php");
	require_once("db.php");
	require_once("functions.php");
	
	error_reporting(0);

	class API extends REST {

		private $functions = NULL;
		private $db = NULL;

		public function __construct() {
			$this->db = new DB();
			$this->functions = new functions($this->db);
		}

		public function check_connection() {
			$this->functions->checkConnection();
		}

		/*
		 * ALL API Related android client -------------------------------------------------------------------------
		*/

		public function get_home() {
			$this->functions->getHome();
		}

		public function get_recent_radio() {
			$this->functions->getRecentRadio();
		}

		public function get_category_index() {
	        $this->functions->getCategoryIndex();
	    }

		public function get_category_detail() {
	        $this->functions->getCategoryDetail();
	    }

	    public function get_search_results() {
	        $this->functions->getSearchResults();
	    }

	    public function get_search_results_rtl() {
	        $this->functions->getSearchResultsRTL();
	    }

	    public function get_privacy_policy() {
	        $this->functions->getPrivacyPolicy();
	    }

	    public function get_settings() {
	        $this->functions->getSettings();
	    }

	    public function get_new_settings() {
	        $this->functions->getNewSettings();
	    }

	    public function get_social() {
	        $this->functions->getSocial();
	    }

	    public function get_user_token() {
	        $this->functions->getUserToken();
	    }

	    public function update_view() {
	        $this->functions->updateView();
	    }

		/*
		 * End of API Transactions ----------------------------------------------------------------------------------
		*/

		public function processApi() {
			if(isset($_REQUEST['x']) && $_REQUEST['x']!=""){
				$func = strtolower(trim(str_replace("/","", $_REQUEST['x'])));
				if((int)method_exists($this,$func) > 0) {
					$this->$func();
				} else {
					$respon = array('status' => 'failed');
					$this->response($this->json($respon), 200);
					exit;
				}
			} else {
				$respon = array('code' => '403', 'message' => 'processApi - method not exist');
				$this->response($this->json($respon), 200);
				exit;
			}
		}

	}

	// Initiiate Library
	$api = new API;
	if (isset($_GET['home'])) {
		$api->get_home();
	} else if (isset($_GET['radios'])) {
		$api->get_recent_radio();
	} else if (isset($_GET['categories'])) {
		$api->get_category_index();
	} else if (isset($_GET['category_detail'])) {
		$api->get_category_detail();
	} else if (isset($_GET['search'])) {
		$api->get_search_results();
	} else if (isset($_GET['search_rtl'])) {
		$api->get_search_results_rtl();
	} else if (isset($_GET['settings'])) {
		$api->get_settings();
	} else if (isset($_GET['setting'])) {
		$api->get_new_settings();
	} else if (isset($_GET['social'])) {
		$api->get_social();
	} else if (isset($_GET['get_user_token'])) {
		$api->get_user_token();
	} else if (isset($_GET['update_view'])) {
		$api->update_view();
	} else if (isset($_GET['check_connection'])) {
		$api->check_connection();
	} else {
		$api->processApi();
	}

?>
